//
//  GSRtParamViewController.m
//  RtSDKDemo
//
//  Created by Sheng on 2018/8/16.
//  Copyright © 2018年 gensee. All rights reserved.
//

#import "GSRtParamViewController.h"
#import "GSTextFieldTitleView.h"
#import "IQKeyboardManager.h"
#import <RtSDK/RtSDK.h>
#import <GSCommonKit/GSCommonKit.h>


#define FASTSDK_COLOR16(value) [UIColor colorWithRed:((float)((value & 0xFF0000) >> 16))/255.0 green:((float)((value & 0xFF00) >> 8))/255.0 blue:((float)(value & 0xFF))/255.0 alpha:1.0]
#define MO_DOMAIN @"FAST_CONFIG_DOMAIN"
#define MO_SERVICE @"FAST_CONFIG_SERVICE_TYPE"
#define MO_ROOMID @"FAST_CONFIG_ROOMID"
#define MO_NICKNAME @"FAST_CONFIG_NICKNAME"
#define MO_PWD @"FAST_CONFIG_PWD"
#define MO_LOGIN_NAME @"FAST_CONFIG_LOGIN_NAME"
#define MO_LOGIN_PWD @"FAST_CONFIG_LOGIN_PWD"
#define MO_THIRD_KEY @"FAST_CONFIG_THIRD_KEY"
#define MO_REWARD @"FAST_CONFIG_REWARD"
#define MO_USERID @"FAST_CONFIG_USERID"

#define ContainVod 0

@interface GSRtParamViewController ()
//UI
@property (nonatomic, strong) UIScrollView  *scrollView;
@property (nonatomic, strong) NSMutableDictionary  *fieldViewsDic;
//config
@property (strong, nonatomic) UISegmentedControl *serviceType;
@property (strong, nonatomic) UISegmentedControl *httpType;
@property (strong, nonatomic) UISegmentedControl *boxType;
@property (strong, nonatomic) UISegmentedControl *allowRoleType;

//编解码
@property (strong, nonatomic) UISegmentedControl *encodeType;
@property (strong, nonatomic) UISegmentedControl *decodeType;
@property (strong, nonatomic) UISegmentedControl *ASDecodeType;

//发布端参数
@property (strong, nonatomic) UISegmentedControl *sdkPublishType;
@property (strong, nonatomic) UISegmentedControl *sdkPublishQualityType;
@property (strong, nonatomic) UISegmentedControl *sdkPublishCropMode;





@end

@implementation GSRtParamViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    NSDictionary*infoDictionary = [[NSBundle mainBundle] infoDictionary];
    NSString*app_Version = [infoDictionary objectForKey:@"CFBundleShortVersionString"];
    NSString*app_build = [infoDictionary objectForKey:@"CFBundleVersion"];
    
    //UI
    self.title = [NSString stringWithFormat:@"GLiveSDK(%@,%@)",app_Version,app_build];
    self.view.backgroundColor = [UIColor groupTableViewBackgroundColor];
    _fieldViewsDic = [[NSMutableDictionary alloc]init];
    self.scrollView                     = [[UIScrollView alloc] initWithFrame:CGRectMake(0, 64 + UIView.additionaliPhoneXTopSafeHeight, Width, Height - 64 - 50 - UIView.additionaliPhoneXTopSafeHeight - UIView.additionaliPhoneXBottomSafeHeight)];
    self.scrollView.keyboardDismissMode = UIScrollViewKeyboardDismissModeOnDrag;
    self.scrollView.alwaysBounceVertical = YES;
    [self.view addSubview:self.scrollView];
    CGFloat top = 10.f;
    int index = 0;
    
    UILabel *label = [self createTagLabel:@"直播参数设置" top:top];
    [self.scrollView addSubview:label];
    top = label.bottom + 5;
    
    UIView *whiteBGView  = [self createWhiteBGViewWithTop:top itemCount:8];
    top = whiteBGView.bottom + 10;
    [self.scrollView addSubview:whiteBGView];
    {
        GSTextFieldTitleView *fieldView       = [[GSTextFieldTitleView alloc] initWithFrame:CGRectMake(0, index * 40.f, Width, 40.f)];
        fieldView.title                     = @"域名";
        fieldView.placeHolder               = @"请输入域名";
        fieldView.field.clearButtonMode = UITextFieldViewModeAlways;
        [whiteBGView addSubview:fieldView];
        [_fieldViewsDic setObject:fieldView forKey:MO_DOMAIN];
        index ++;
    }
    {
        GSTextFieldTitleView *fieldView       = [[GSTextFieldTitleView alloc] initWithFrame:CGRectMake(0, index * 40.f, Width, 40.f)];
        fieldView.title                     = @"房间号";
        fieldView.placeHolder               = @"请输入房间号";
        fieldView.field.clearButtonMode = UITextFieldViewModeAlways;
        fieldView.field.keyboardType = UIKeyboardTypeNumberPad;
        [whiteBGView addSubview:fieldView];
        [_fieldViewsDic setObject:fieldView forKey:MO_ROOMID];
        index ++;
    }
    {
        GSTextFieldTitleView *fieldView       = [[GSTextFieldTitleView alloc] initWithFrame:CGRectMake(0, index * 40.f, Width, 40.f)];
        fieldView.title                     = @"昵称";
        fieldView.placeHolder               = @"请输入昵称";
        fieldView.field.clearButtonMode = UITextFieldViewModeAlways;
        [whiteBGView addSubview:fieldView];
        [_fieldViewsDic setObject:fieldView forKey:MO_NICKNAME];
        index ++;
    }
    {
        GSTextFieldTitleView *fieldView       = [[GSTextFieldTitleView alloc] initWithFrame:CGRectMake(0, index * 40.f, Width, 40.f)];
        fieldView.title                     = @"房间密码";
        fieldView.placeHolder               = @"请输入房间密码(可选)";
        fieldView.field.clearButtonMode = UITextFieldViewModeAlways;
//        fieldView.field.keyboardType = UIKeyboardTypeNumberPad;
        [whiteBGView addSubview:fieldView];
        [_fieldViewsDic setObject:fieldView forKey:MO_PWD];
        index ++;
    }
    {
        GSTextFieldTitleView *fieldView       = [[GSTextFieldTitleView alloc] initWithFrame:CGRectMake(0, index * 40.f, Width, 40.f)];
        fieldView.title                     = @"登录用户名";
        fieldView.placeHolder               = @"请输入登录用户名(可选)";
        fieldView.field.clearButtonMode = UITextFieldViewModeAlways;
        [whiteBGView addSubview:fieldView];
        [_fieldViewsDic setObject:fieldView forKey:MO_LOGIN_NAME];
        index ++;
    }
    {
        GSTextFieldTitleView *fieldView       = [[GSTextFieldTitleView alloc] initWithFrame:CGRectMake(0, index * 40.f, Width, 40.f)];
        fieldView.title                     = @"登录密码";
        fieldView.placeHolder               = @"请输入登录密码(可选)";
        fieldView.field.clearButtonMode = UITextFieldViewModeAlways;
        [whiteBGView addSubview:fieldView];
        [_fieldViewsDic setObject:fieldView forKey:MO_LOGIN_PWD];
        index ++;
    }
    {
        GSTextFieldTitleView *fieldView       = [[GSTextFieldTitleView alloc] initWithFrame:CGRectMake(0, index * 40.f, Width, 40.f)];
        fieldView.title                     = @"第三方验证码";
        fieldView.placeHolder               = @"请输入验证码(可选)";
        fieldView.field.clearButtonMode = UITextFieldViewModeAlways;
        [whiteBGView addSubview:fieldView];
        [_fieldViewsDic setObject:fieldView forKey:MO_THIRD_KEY];
        index ++;
    }
    {
        GSTextFieldTitleView *fieldView       = [[GSTextFieldTitleView alloc] initWithFrame:CGRectMake(0, index * 40.f, Width, 40.f)];
        fieldView.title                     = @"自定义用户ID";
        fieldView.placeHolder               = @"请输入ID(可选,且应大于十亿)";
        fieldView.field.clearButtonMode = UITextFieldViewModeAlways;
        fieldView.field.keyboardType = UIKeyboardTypeNumberPad;
        [whiteBGView addSubview:fieldView];
        [_fieldViewsDic setObject:fieldView forKey:MO_USERID];
        index ++;
    }
    
    //segement
    {
        UILabel *label = [self createTagLabel:@"站点类型" top:top];
        [self.scrollView addSubview:label];
        UILabel *label1 = [self createTagLabel:@"网络请求类型" top:top left:Width/2 + 15];
        [self.scrollView addSubview:label1];
        top = label.bottom + 5;
        //Webcast/Trainig
        _serviceType = [[UISegmentedControl alloc] initWithItems:@[@"Webcast",@"Training"]];
        _serviceType.frame = CGRectMake(15, top, (Width - 60)/2, 28);
        _serviceType.tag = 0;
        _serviceType.selectedSegmentIndex = 0;
        [self.scrollView addSubview:_serviceType];
        //Theme
        _httpType = [[UISegmentedControl alloc] initWithItems:@[@"HTTP",@"HTTPS"]];
        _httpType.frame = CGRectMake(Width/2 + 15, top, (Width - 60)/2, 28);
        _httpType.selectedSegmentIndex = 0;
        _httpType.tag = 1;
        [self.scrollView addSubview:_httpType];
        
        top = _httpType.bottom + 10;
        
    }
    
    //segement
    {
        UILabel *label = [self createTagLabel:@"box用户" top:top];
        [self.scrollView addSubview:label];
        
        UILabel *label1 = [self createTagLabel:@"直播类型(SDK功能)" top:top left:Width/2 + 15];
        [self.scrollView addSubview:label1];
        top = label.bottom + 5;
        //Webcast/Trainig
        _boxType = [[UISegmentedControl alloc] initWithItems:@[@"否",@"是"]];
        _boxType.frame = CGRectMake(15, top, (Width - 60)/2, 28);
        _boxType.tag = 0;
        _boxType.selectedSegmentIndex = 0;
        [self.scrollView addSubview:_boxType];
        //Theme
        _allowRoleType = [[UISegmentedControl alloc] initWithItems:@[@"观看",@"发布",@"点播"]];
        _allowRoleType.frame = CGRectMake(Width/2 + 15, top, (Width - 60)/2, 28);
        _allowRoleType.selectedSegmentIndex = 0;
        _allowRoleType.tag = 1;
        [self.scrollView addSubview:_allowRoleType];
        
        top = _allowRoleType.bottom + 10;
        
    }
    
    //segement
    {
        UILabel *label = [self createTagLabel:@"软解/硬解" top:top];
        [self.scrollView addSubview:label];
        
        UILabel *label1 = [self createTagLabel:@"桌面共享 软解/硬解" top:top left:Width/2 + 15];
        [self.scrollView addSubview:label1];
        top = label.bottom + 5;
        //Webcast/Trainig
        _decodeType = [[UISegmentedControl alloc] initWithItems:@[@"硬解",@"软解"]];
        _decodeType.frame = CGRectMake(15, top, (Width - 60)/2, 28);
        _decodeType.tag = 0;
        _decodeType.selectedSegmentIndex = 1;
        
        [self.scrollView addSubview:_decodeType];
        //Theme
        _ASDecodeType = [[UISegmentedControl alloc] initWithItems:@[@"软解",@"硬解"]];
        _ASDecodeType.frame = CGRectMake(Width/2 + 15, top, (Width - 60)/2, 28);
        _ASDecodeType.selectedSegmentIndex = 1;
        _ASDecodeType.tag = 1;
        [self.scrollView addSubview:_ASDecodeType];
        
        top = _ASDecodeType.bottom + 10;
        
    }
    
    //segement
    {
        UILabel *label = [self createTagLabel:@"硬编/软编" top:top];
        [self.scrollView addSubview:label];

        top = label.bottom + 5;
        //Webcast/Trainig
        _encodeType = [[UISegmentedControl alloc] initWithItems:@[@"硬编",@"软编"]];
        _encodeType.frame = CGRectMake(15, top, (Width - 60)/2, 28);
        _encodeType.tag = 2;
        _encodeType.selectedSegmentIndex = 0;
        [self.scrollView addSubview:_encodeType];
 
        top = _encodeType.bottom + 10;
        
    }
    
    //video config dpis
    {
        UILabel *label = [self createTagLabel:@"发布端视频设置参数，仅发布端生效" top:top];
        [self.scrollView addSubview:label];
        top = label.bottom + 5;
        
        //segement
        {
            UILabel *label = [self createTagLabel:@"发布端类型" top:top];
            [self.scrollView addSubview:label];
            UILabel *label1 = [self createTagLabel:@"发布端视频质量" top:top left:Width/2 + 15];
            [self.scrollView addSubview:label1];
            top = label.bottom + 5;
            _sdkPublishType = [[UISegmentedControl alloc] initWithItems:@[@"分屏",@"竖屏",@"横屏"]];
            _sdkPublishType.frame = CGRectMake(15, top, (Width - 60)/2, 28);
            _sdkPublishType.tag = 0;
            _sdkPublishType.selectedSegmentIndex = 0;
            [self.scrollView addSubview:_sdkPublishType];
            //Theme
            _sdkPublishQualityType = [[UISegmentedControl alloc] initWithItems:@[@"标清",@"高清",@"超清"]];
            _sdkPublishQualityType.frame = CGRectMake(Width/2 + 15, top, (Width - 60)/2, 28);
            _sdkPublishQualityType.selectedSegmentIndex = 0;
            _sdkPublishQualityType.tag = 1;
            [self.scrollView addSubview:_sdkPublishQualityType];
            
            top = _sdkPublishQualityType.bottom + 10;
            
        }
        
        //segement
        {
            UILabel *label = [self createTagLabel:@"发布端分屏视频发布比例（竖屏强制为9:16 横屏强制为4:3)" top:top];
            [self.scrollView addSubview:label];
            
//            UILabel *label1 = [self createTagLabel:@"直播类型(SDK功能)" top:top left:Width/2 + 15];
//            [self.scrollView addSubview:label1];
            top = label.bottom + 5;
            
            _sdkPublishCropMode = [[UISegmentedControl alloc] initWithItems:@[@"4:3",@"16:9"]];
            _sdkPublishCropMode.frame = CGRectMake(15, top, (Width - 60)/2, 28);
            _sdkPublishCropMode.tag = 0;
            _sdkPublishCropMode.selectedSegmentIndex = 0;
            [self.scrollView addSubview:_sdkPublishCropMode];
//            //Theme
//            _allowRoleType = [[UISegmentedControl alloc] initWithItems:@[@"观看",@"发布",@"点播"]];
//            _allowRoleType.frame = CGRectMake(Width/2 + 15, top, (Width - 60)/2, 28);
//            _allowRoleType.selectedSegmentIndex = 0;
//            _allowRoleType.tag = 1;
//            [self.scrollView addSubview:_allowRoleType];
            
            top = _sdkPublishCropMode.bottom + 10;
            
        }
        

        
    }
    
    //NSUserDefault
    [self loadCache];
    
    self.scrollView.contentSize = CGSizeMake(Width, top);
    
    {
        

        UIButton *watch   = [[UIButton alloc] initWithFrame:CGRectMake(15.f, self.scrollView.y + self.scrollView.height + 5, Width - 30.f, 40.f)];
        [watch setTitle:@"下一步" forState:UIControlStateNormal];
        watch.layer.cornerRadius         = 3.f;
        watch.layer.borderColor          = FASTSDK_COLOR16(0x009BD8).CGColor;
        watch.layer.borderWidth          = 0.5f;
        watch.layer.masksToBounds        = YES;
        watch.backgroundColor = FASTSDK_COLOR16(0x009BD8);
        [watch addTarget:self action:@selector(watch:) forControlEvents:UIControlEventTouchUpInside];
        [self.view addSubview:watch];
    }
}

- (void)vodAction:(UIButton *)sender {

}

- (void)watch:(UIButton*)sender {
    sender.userInteractionEnabled = NO;
    //存储相关参数到NSUserDefault
    [self saveCache];
    GLiveFastConfig *config = [[GLiveFastConfig alloc] init];
    //param
    GSConnectInfo *params = [GSConnectInfo new];
#if 1
    params.domain = [self _fieldText:MO_DOMAIN];
    params.roomNumber = [self _fieldText:MO_ROOMID];
    params.loginName = [self _fieldText:MO_LOGIN_NAME];
    params.watchPassword = [self _fieldText:MO_PWD];
    params.loginPassword = [self _fieldText:MO_LOGIN_PWD];
    params.nickName = [self _fieldText:MO_NICKNAME];
    
#else
    //213.gensee.com/training/site/r/59271145
    params.domain = @"chinaedu.gensee.com";
    params.roomNumber = @"24492084";
//        params.webcastID = @"LHf792RWRc";
    params.watchPassword = @"student_w3qaKp";
    params.nickName = @"support";
    params.serviceType = self.serviceType.selectedSegmentIndex == 0?0:1;
    params.oldVersion = NO;

#endif
    params.serviceType = self.serviceType.selectedSegmentIndex==0?GSBroadcastServiceTypeWebcast:GSBroadcastServiceTypeTraining;
    params.thirdToken = [self _fieldText:MO_THIRD_KEY];
    if ([self _fieldText:MO_USERID].length > 0) {
        params.customUserID = [[self _fieldText:MO_USERID] longLongValue];
    }
    params.oldVersion = self.boxType.selectedSegmentIndex;

    //config设置
    config.httpAPIEnabled = (self.httpType.selectedSegmentIndex==0)?YES:NO;
    config.hardwareAccelerateVideoDecodeSupport = (self.decodeType.selectedSegmentIndex==0)?YES:NO;
    config.hardwareAccelerateASDecodeSupport = (self.ASDecodeType.selectedSegmentIndex==0)?NO:YES;
    config.hardwareAccelerateEncodeSupport = (self.encodeType.selectedSegmentIndex==0)?YES:NO;
    
    switch (self.allowRoleType.selectedSegmentIndex) {
        case 0:
            config.sdkType = GLiveFastSDKTypeWatch;
            break;
        case 1:
            config.sdkType = GLiveFastSDKTypePublish;
            break;
        case 2:
            config.sdkType = GLiveFastSDKTypeVod;
            break;
        default:
            break;
    }
    
    switch (self.sdkPublishType.selectedSegmentIndex) {
        case 0:
            config.sdkPublishType = GLiveFastSDKPublishTypeNormal;
            break;
        case 1:
            config.sdkPublishType = GLiveFastSDKPublishTypePortrait;
            break;
        case 2:
            config.sdkPublishType = GLiveFastSDKPublishTypeLandScape;
            break;
        default:
            break;
    }
    
    switch (self.sdkPublishQualityType.selectedSegmentIndex) {
        case 0:
            config.sdkPublishQualityType = GLiveFastSDKPublishQualityTypeNormal;
            break;
        case 1:
            config.sdkPublishQualityType = GLiveFastSDKPublishQualityTypeHigh;
            break;
        case 2:
            config.sdkPublishQualityType = GLiveFastSDKPublishQualityTypeLive;
            break;
        default:
            break;
    }
    
    switch (self.sdkPublishCropMode.selectedSegmentIndex) {
        case 0:
            config.sdkPublishCropMode = GLiveFastSDKPublishCropMode4_3;
            break;
        case 1:
            config.sdkPublishCropMode = GLiveFastSDKPublishCropMode16_9;
            break;
        default:
            break;
    }

    //设置间隔
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(2 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        sender.userInteractionEnabled = YES;
    });
    
    [[GLiveFastSDK sharedInstance] joinWithGSConnectInfo:params config:config];
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [[IQKeyboardManager sharedManager] setEnable:YES];
    self.automaticallyAdjustsScrollViewInsets = NO;
}
//data
#pragma mark - data

- (void)saveCache {
    [[NSUserDefaults standardUserDefaults] setObject:[NSNumber numberWithInteger:self.serviceType.selectedSegmentIndex] forKey:MO_SERVICE];
    [self _saveField:MO_DOMAIN];
    [self _saveField:MO_ROOMID];
    [self _saveField:MO_NICKNAME];
    [self _saveField:MO_PWD];
    [self _saveField:MO_LOGIN_NAME];
    [self _saveField:MO_LOGIN_PWD];
    [self _saveField:MO_THIRD_KEY];
    [self _saveField:MO_USERID];
    
}

- (void)_saveField:(NSString *)fieldMark {
    NSString *text = [self _fieldText:fieldMark];
    if (text.length > 0) {
        [[NSUserDefaults standardUserDefaults] setObject:text forKey:fieldMark];
    }else{
        if ([[NSUserDefaults standardUserDefaults] objectForKey:fieldMark]) {
            [[NSUserDefaults standardUserDefaults] setObject:@"" forKey:fieldMark];
        }
    }
}

- (NSString *)_fieldText:(NSString *)fieldMark {
    GSTextFieldTitleView *fieldView = [_fieldViewsDic objectForKey:fieldMark];
    return fieldView.field.text;
}

- (void)loadCache {
    if (![[NSUserDefaults standardUserDefaults] objectForKey:MO_DOMAIN]) {
        [[NSUserDefaults standardUserDefaults] setObject:@"213.gensee.com" forKey:MO_DOMAIN];
    }else{
        GSTextFieldTitleView *fieldview = [_fieldViewsDic objectForKey:MO_DOMAIN];
        fieldview.field.text = [[NSUserDefaults standardUserDefaults] objectForKey:MO_DOMAIN];
    }
    
    if (![[NSUserDefaults standardUserDefaults] objectForKey:MO_SERVICE]) {
        [[NSUserDefaults standardUserDefaults] setObject:@0 forKey:MO_SERVICE];
    }else{
        self.serviceType.selectedSegmentIndex = [[[NSUserDefaults standardUserDefaults] objectForKey:MO_SERVICE] intValue];
    }
    if (![[NSUserDefaults standardUserDefaults] objectForKey:MO_ROOMID]) {
        [[NSUserDefaults standardUserDefaults] setObject:@"38738043" forKey:MO_ROOMID];
    }else{
        GSTextFieldTitleView *fieldview = [_fieldViewsDic objectForKey:MO_ROOMID];
        fieldview.field.text = [[NSUserDefaults standardUserDefaults] objectForKey:MO_ROOMID];
    }
    if (![[NSUserDefaults standardUserDefaults] objectForKey:MO_NICKNAME]) {
        [[NSUserDefaults standardUserDefaults] setObject:@"support" forKey:MO_NICKNAME];
    }else{
        GSTextFieldTitleView *fieldview = [_fieldViewsDic objectForKey:MO_NICKNAME];
        fieldview.field.text = [[NSUserDefaults standardUserDefaults] objectForKey:MO_NICKNAME];
    }
    if (![[NSUserDefaults standardUserDefaults] objectForKey:MO_PWD]) {
        [[NSUserDefaults standardUserDefaults] setObject:@"" forKey:MO_PWD];
    }else{
        GSTextFieldTitleView *fieldview = [_fieldViewsDic objectForKey:MO_PWD];
        fieldview.field.text = [[NSUserDefaults standardUserDefaults] objectForKey:MO_PWD];
    }
    
    if (![[NSUserDefaults standardUserDefaults] objectForKey:MO_LOGIN_NAME]) {
        //do nothing
    }else{
        GSTextFieldTitleView *fieldview = [_fieldViewsDic objectForKey:MO_LOGIN_NAME];
        fieldview.field.text = [[NSUserDefaults standardUserDefaults] objectForKey:MO_LOGIN_NAME];
    }
    if (![[NSUserDefaults standardUserDefaults] objectForKey:MO_LOGIN_PWD]) {
        //do nothing
    }else{
        GSTextFieldTitleView *fieldview = [_fieldViewsDic objectForKey:MO_LOGIN_PWD];
        fieldview.field.text = [[NSUserDefaults standardUserDefaults] objectForKey:MO_LOGIN_PWD];
    }
    if (![[NSUserDefaults standardUserDefaults] objectForKey:MO_THIRD_KEY]) {
        //do nothing
    }else{
        GSTextFieldTitleView *fieldview = [_fieldViewsDic objectForKey:MO_THIRD_KEY];
        fieldview.field.text = [[NSUserDefaults standardUserDefaults] objectForKey:MO_THIRD_KEY];
    }
    
    if (![[NSUserDefaults standardUserDefaults] objectForKey:MO_USERID]) {
        //do nothing
    }else{
        GSTextFieldTitleView *fieldview = [_fieldViewsDic objectForKey:MO_USERID];
        fieldview.field.text = [[NSUserDefaults standardUserDefaults] objectForKey:MO_USERID];
    }
    
}

- (void)dealloc {
    [_fieldViewsDic removeAllObjects];
    NSLog(@"GSRtParamViewController dealloc");
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}
@end
